<?php
session_start();
include "portal_admin.php";

$portal = new PortalAdmin();
try{
  $portal->initDB("localhost", "php", "test", "testphp");
}
catch(Exception $e){
  //echo 'Brak połączenia z bazą danych.';
  //exit();
}

//Sprawdzenie czy jest parametr action.
if (isset($_GET['action'])) {
  $action = $_GET['action'];
}
else{
  $action = 'showMainAdmin';
}

//Wykonanie procedury logowania lub wylogowania.
switch($action):
  case 'login':
    if(!isset($_SESSION['zalogowany_adm']))
    switch($portal->login()){
      case LOGIN_OK:
        unset ($_SESSION['komunikat_adm']);
        break;
      case LOGIN_FAILED:
        $_SESSION['komunikat_adm'] = "Nieprawidłowa nazwa lub hasło!";
        break;
      case NO_ADMIN_RIGHTS:
        $_SESSION['komunikat_adm'] = "Brak uprawnień administracyjnych!";
        $portal->logout();
        break;
      case SERVER_ERROR:
      default:
        $_SESSION['komunikat_adm'] = "Błąd serwera!";
        $portal->logout();
    }
    break;
  case 'logout':
    $portal->logout();
    break;
endswitch;

//Ustalenie akcji dla niezalogowanego użytkownika.
if(!isset($_SESSION['zalogowany_adm'])){
  $action = 'showLoginForm';
}

?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<link rel="stylesheet" type="text/css" href="style.css">
<title>Portal (administracja)</title>
</head>
<body>
<div id="topDiv">
<?php
  //Uwzględniaj poniższą warstwę tylko dla zalogowanych.
?>
<div id="headerDiv">
  Funkcje:
  <span class='headerLinks'><a href='index.php?action=usersAdmin'>
  Zarządzanie użytkownikami</a> | 
  <a href="index.php?action=logout">Wyloguj</a>
  </span>
</div>
<?php
  //Koniec instrukcji warunkowej.
?>
<div id="mainContentDiv">
<?php
switch($action):
  case 'showLoginForm' :
    include 'admin_login_form.php';
    break;
  case 'usersAdmin' :
    include 'usersAdminMenu.php';
    $portal->userAdmin();
    break;
  case 'showMainAdmin':
  default:
?>
Wybierz z funkcję administracyjną z menu.
<?php
endswitch;
?>
</div>
</div>
</body>
</html>
